;								EJEMPLO 36
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El mdulo USART. Transmisin asncrona
;
;El mdulo USART de los dispositivos PIC16F87X incorpora el hardware necesario para implemen-
;tar comunicacin serie asncrona full-duplex o sincrona half-duplex. En este ltimo caso el
;USART se puede comportar como Master o Slave.
;
;El ejemplo transmite una trama cada segundo con el caracter ASCII de la letra A.

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Delay		equ	0x20		;variable de temporizacin

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x04		;Vector de interrupcin
			goto	Inter
			org	0x05
		
;********************************************************************************************
;Tx_Dato: Transmite va serie el dato presente en el reg. W

Tx_Dato			movwf	TXREG		;Almacena el byte a transmitir
				bsf		STATUS,RP0
Tx_Dato_Wait	btfss	TXSTA,TRMT	;Byte transmitido ??
				goto	Tx_Dato_Wait	;No, esperar
				bcf		STATUS,RP0
				return				;Si

;********************************************************************************************
;Tratamiento de interrupcin. Se espera que el TMR0 rebase 100 veces para un delay de 1 s. 
;Entonces se transmite el caracter

Inter			bcf	INTCON,T0IF	;Restaura el flag del TMR0
				movlw	~.39
				movwf	TMR0	;Reponer el TMR0
				decfsz	Delay,F	;Se han provocado 100 rebasamientos de 10mS (1s.) ?
				retfie			;Todava no

				movlw	.100
				movwf	Delay	;Reponer variable de temporizacin con el valor 20
				movlw	'A'
				call	Tx_Dato	;Transmite el dato
				retfie

;*******************************************************************************************
;Programa principal

Inicio	     	clrf	PORTC		
				bsf		STATUS,RP0	;Selecciona banco 1
				movlw	b'10111111'
				movwf	TRISC		;RC7/Rx entrada, RC6/Tx salida
				movlw	b'11000111'
				movwf	OPTION_REG	;Preescaler de 256 asociado al TMR0
				movlw	b'00100100'	
				movwf	TXSTA		;TX en On, modo asncrono con 8 bits y alta velocidad
				movlw	.25
				movwf	SPBRG		;9600 baudios con Fosc=4MHz

				bcf		STATUS,RP0	;Selecciona banco 0
				bsf		RCSTA,SPEN	;USART en On

;Trabajando a 4MHz y con un preescaler de 256, el TMR0 se carga con 39 para conseguir que
;rebase cada 10mS. Esto se repite tantas veces como indique la variable Delay para 
;obtener la temporizacin final deseada.

				bcf		INTCON,T0IF	;Restaura el flag del TMR0
				movlw	~.39
				movwf	TMR0		;El TMR0 rebasa cada 10 mS
				movlw	.100
				movwf	Delay		;Repetir 100 veces para obtener 1 seg.
				movlw	b'10100000'
				movwf	INTCON		;Habilita interrupcin del TMR0

Loop			nop
				goto	Loop

				end					;Fin del programa fuente
